/*
Copyright © 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/
var isPlaying = false;
var hasSong = false;
var volume = 0;
var isMouseDown = false;
var currentPosition = 0;
var duration = 0;
var sliderWidth = 130;
var knobLeftmost = 114;
var draggingSlider = false;
var running = false;
var backside = false;
var gLastPlaylist = 0; //  default to "Library"
var gPlaylistChanged = false;
var shuffleState = false;
var repeatState = "off";

function getLocalizedString (key)
{
	try {
		var string = localizedStrings[key];
		if (null != string)
			return string;
		else
			return key;
	} catch (ex) {}

	return key;
}

function mouseMove(e) {
	if (draggingSlider) {
		iTunes.setPlayPosition(((e.pageX-knobLeftmost)/sliderWidth) * duration);
		var dk = document.getElementById("dk");
		dk.style.pixelLeft = e.pageX;
		
		if (dk.style.pixelLeft > knobLeftmost + sliderWidth)
			dk.style.pixelLeft = knobLeftmost + sliderWidth;
		else if (dk.style.pixelLeft < knobLeftmost)
			dk.style.pixelLeft = knobLeftmost;
	}
}

function sliderMouseUp (e)
{
	document.removeEventListener("mousemove", mouseMove, true);
	document.removeEventListener("mouseup", sliderMouseUp, true);
}


function mouseOut(e, tag) {
	switch (tag) {
		case "dk":
			draggingSlider = false;
			break;
	}
	e.stopPropagation();
}

function mouseDown(e, tag) {
	switch(tag) {
		case "ds":
			if (duration)
				iTunes.setPlayPosition((e.layerX/sliderWidth) * duration);
			break;
		case "dk":
			if (duration) {
				iTunes.setPlayPosition(((e.pageX-knobLeftmost)/sliderWidth) * duration);
				var dk = document.getElementById("dk");
				dk.style.pixelLeft = e.pageX;
				draggingSlider = true;
				document.addEventListener("mousemove", mouseMove, true);
				document.addEventListener("mouseup", sliderMouseUp, true);
			}
			break;
		case "prev":
			var fb = document.getElementById("fb");
			fb.src = "Images/dback.png";
			break;
		case "next":
			var fb = document.getElementById("fb");
			fb.src = "Images/dforward.png";
			break;
		case "pl":
			e.target.src = ((isPlaying || !hasSong) ? "Images/dpause.png" : "Images/dplay.png");
			break;
		default:
			break;
	}
	
	isMouseDown = true;
	
	e.stopPropagation();
	e.preventDefault();
}

function mouseUp(e, tag) {
	switch(tag) {
		case "prev":
			iTunes.previous();
			var fb = document.getElementById("fb");
			fb.src = "Images/forwardBack.png";
			break;
		case "next":
			iTunes.next();
			var fb = document.getElementById("fb");
			fb.src = "Images/forwardBack.png";
			break;
		case "pl":
			if (gPlaylistChanged)
				iTunes.playPlaylist();
			else
				iTunes.playPause();
			e.target.src = ((isPlaying || !hasSong) ? "Images/play.png" : "Images/pause.png");
			break;
		default:
			break;
	}
	
	isMouseDown = false;
}

function go_to_tunes_mousedown (e)
{
	e.stopPropagation();
	e.preventDefault();

}

function go_to_tunes ()
{
	if (window.widget) {
		widget.openApplication ("com.apple.iTunes");
	}
}

function updatePosition() {
	var dk = document.getElementById("dk");
	
	if ((duration != 0)) {
		var xPos = (currentPosition/duration) * sliderWidth;
		if (xPos > sliderWidth)
			xPos = sliderWidth;
			
		dk.style.pixelLeft = knobLeftmost + xPos;
	} else {
		
		dk.style.pixelLeft = knobLeftmost;
	}
}

function updateDisplay() {
	if (window.iTunes) {
		var pos = "0:00";
		var title;
		
		running = iTunes.update();
		
		if (running) {
			isPlaying = iTunes.isPlaying();
			
			duration = iTunes.duration();
			if (!duration)
				duration = 0;
			currentPosition = iTunes.playerPosition();
			if (!currentPosition)
				pos = "0:00";
			else {
				mins = Math.floor(currentPosition / 60);
				secs = currentPosition % 60;
				pos = mins + ":" + ((secs < 10) ? "0" : "") + secs;
			}
					
			title = iTunes.currentTitle();
			if ((title == "missing value") || !title)
			{
				title = getLocalizedString("No song.");
				hasSong = false;	
			}
			else
				hasSong = true;
				
			if (!draggingVolume) {
				volume = iTunes.volume();
				if ((volume == "missing value") || !volume)
					volume = 0;
			}
			
			if (!isMouseDown) {
				var e = document.getElementById("pl");
				e.src = (isPlaying ? "Images/pause.png" : "Images/play.png");
			}
			
		} else {
			title = getLocalizedString("iTunes not running.");
			var e = document.getElementById("pl");
			e.src = "Images/play.png";
		}
	
		updatePosition();
		
		var td = document.getElementById("timeDisplay");
		td.innerText = pos;
	
		var titleDisplay = document.getElementById("titleDisplay");
		titleDisplay.innerText = title;
	}
}

var ourTimer = null;

function pageloaded() {
	if (iTunes)
		iTunes.updateIsAppRunning();
	
	// set the control regions here
	
	ourTimer = setInterval("updateDisplay();", 500);
	var dl = document.getElementById("dimple");
	dl.style.pixelTop = 7; dl.style.pixelLeft = 54;

	if (window.widget)
	{
		gLastPlaylist = widget.preferenceForKey(createkey("playlistsave"));
		if (gLastPlaylist == null)
			gLastPlaylist = 0;
		if (iTunes) iTunes.setCurrentPlaylist(gLastPlaylist);
	}
}

if (window.widget) // check to see if the widget object exists
{
	widget.onhide = onhide;
	widget.onshow = onshow;
}


var flipShown = false;

var fadeAnimation = {startTime:0, duration:250, fadeFrom:0, fadeTo:0, fadeNow:0, timer:null, element:null};

function limit_3 (a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

function animate () {
	var T;
	var ease;
	var time  = (new Date).getTime();

	T = limit_3(time-fadeAnimation.startTime, 0, fadeAnimation.duration);
	
	if (T >= fadeAnimation.duration)
	{
		clearInterval (fadeAnimation.timer);
		fadeAnimation.timer = null;
		fadeAnimation.fadeNow = fadeAnimation.fadeTo;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / fadeAnimation.duration));
		fadeAnimation.fadeNow = computeNextFloat (fadeAnimation.fadeFrom, fadeAnimation.fadeTo, ease);
	}
	
	fadeAnimation.element.style.opacity = fadeAnimation.fadeNow;
}

function onshow ()
{
	if (iTunes)
		iTunes.updateIsAppRunning();
	
	if (ourTimer == null)
	{
		updateDisplay(); // reload we just shown
		ourTimer = setInterval("updateDisplay()", 500);
	}
	if (running)
		updatePlaylists();
}


function onhide ()
{
	if (ourTimer != null)
	{
		// we were hidden clear the timer.
		clearInterval(ourTimer);
		ourTimer = null;
	}
}

function createkey(key)
{
	return widget.identifier + "-" + key;
}

var draggingVolume = false;
function iFadeIn(e) {
	if (!flipShown)
	{
		// fade in the flip widget
		if (fadeAnimation.timer != null)
		{
			clearInterval (fadeAnimation.timer);
			fadeAnimation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		fadeAnimation.duration = 500;
		fadeAnimation.startTime = starttime;
		fadeAnimation.element = document.getElementById ('flip');
		fadeAnimation.timer = setInterval ("animate();", 13);
		fadeAnimation.fadeFrom = fadeAnimation.fadeNow;
		fadeAnimation.fadeTo = 0.5;
		animate();
		flipShown = true;
	}
	
	e.stopPropagation();
	e.preventDefault();
}

function iFadeOut(e) {
	if (flipShown)
	{
		// fade out the flip widget
		if (fadeAnimation.timer != null)
		{
			clearInterval (fadeAnimation.timer);
			fadeAnimation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; // set it back one frame
		
		fadeAnimation.duration = 500;
		fadeAnimation.startTime = starttime;
		fadeAnimation.element = document.getElementById ('flip');
		fadeAnimation.timer = setInterval ("animate();", 13);
		fadeAnimation.fadeFrom = fadeAnimation.fadeNow;
		fadeAnimation.fadeTo = 0.0;
		animate();
		flipShown = false;
	}
	
	e.stopPropagation();
	e.preventDefault();
}

function ignoreEvent(e) {
	e.stopPropagation();
	e.preventDefault();
}

function checkVolumeMouseDown(id, e) {
	if (backside) return;
	if (!running) return;
	
	var x = e.clientX - 58;
	var y = e.clientY - 52;
	if (Math.sqrt(x*x + y*y) > 45) return;
	
	beginVolumeChange(e);
	document.addEventListener("mousemove", trackVolumeChange, true);
	document.addEventListener("mouseup", trackVolumeChangeUp, true);
	e.stopPropagation();
	e.preventDefault();
}

var lastDAngle;
var lastAngle;
function beginVolumeChange(e) {
	var slider = document.getElementById("ds");
	var knob = document.getElementById("dk");
	var time = document.getElementById("timeDisplay");
	var volEmpty = document.getElementById("volEmpty");
	var volFilled = document.getElementById("volFilled");
	var sh = document.getElementById("shuffle");
	var rp = document.getElementById("repeat");
	
	slider.style.visibility = "hidden";
	knob.style.visibility = "hidden";
	time.style.visibility = "hidden";
	sh.style.visibility = "hidden";
	rp.style.visibility = "hidden";
	volEmpty.style.visibility = "visible";
	volFilled.style.visibility = "visible";
		
	volFilled.style.clip = "rect(0,"+(volume*1.2)+",15,0)";
	
	draggingVolume = true;
	
	var dl = document.getElementById("dimple");
	lastDAngle = Math.atan2(dl.style.pixelTop - 49, dl.style.pixelLeft - 53);
	lastAngle = Math.atan2(e.pageY-50, e.pageX-50) + Math.PI; // make angle 0-2pi
}

function endVolumeChange() {
	var slider = document.getElementById("ds");
	var knob = document.getElementById("dk");
	var time = document.getElementById("timeDisplay");
	var volEmpty = document.getElementById("volEmpty");
	var volFilled = document.getElementById("volFilled");
	var sh = document.getElementById("shuffle");
	var rp = document.getElementById("repeat");
	
	slider.style.visibility = "visible";
	knob.style.visibility = "visible";
	time.style.visibility = "visible";
	sh.style.visibility = "visible";
	rp.style.visibility = "visible";
	volEmpty.style.visibility = "hidden";
	volFilled.style.visibility = "hidden";

	draggingVolume = false;
}

var lastPoint = {x:0, y:0}
var lastWasClockwise = false;
var ignoreCount = 0;

function trackVolumeChange(e) {
	var volFilled = document.getElementById("volFilled");

	// This is a bogus event that is returned just before mouse-up
	if ((e.pageX == -1) && (e.pageY == 115)) {
		return;
	}
	var angle;
	var x = e.pageX-50;
	var y = e.pageY-50;
	angle = Math.atan2(y, x) + Math.PI;
	var range = Math.sqrt(x*x + y*y);
	var threshold = range > 50? .3: 0;
	if ( (Math.abs(angle - lastAngle) <= threshold) &&
		 (ignoreCount < 3) )
	{
		lastPoint.x = e.pageX;
		lastPoint.y = e.pageY;
		ignoreCount++;
		return;
	}
	ignoreCount = 0;
	
	var dl = document.getElementById("dimple");
	var dAngle = angle - lastAngle;
	if (dAngle > Math.PI) dAngle = angle - (lastAngle + (Math.PI * 2.0));
	if (dAngle < -Math.PI) dAngle = (angle + (Math.PI * 2.0)) - lastAngle;
	lastDAngle += dAngle;
	dl.style.pixelTop = 49 + Math.sin(lastDAngle)*41.5;
	dl.style.pixelLeft = 53 + Math.cos(lastDAngle)*41.0;
	
	var localVolume = volume * 1.2;
	dVolume = (120.0 * dAngle)/Math.PI;
	if (Math.abs(dVolume) < 2) dVolume = (dVolume < 0)? -1: 2;
	localVolume += dVolume;
	if (localVolume >= 120)
		localVolume = 120;
	else if (localVolume <= 0)
		localVolume = 0;
		
	volFilled.style.clip = "rect(0,"+parseInt(localVolume)+",15,0)";
	volume = parseInt(localVolume/1.2);
	iTunes.setVolume(volume);
	
	lastAngle = angle;
	lastPoint.x = e.pageX;
	lastPoint.y = e.pageY;
		
	e.stopPropagation();
	e.preventDefault();
}

function trackVolumeChangeUp(e) {
	document.removeEventListener("mousemove", trackVolumeChange, true);
	document.removeEventListener("mouseup", trackVolumeChangeUp, true);
	endVolumeChange();
	e.stopPropagation();
	e.preventDefault();
}

function showbackside(event)
{
	var front = document.getElementById("body");
	var back = document.getElementById("behind");
	var slider = document.getElementById("ds");
	var knob = document.getElementById("dk");
	var time = document.getElementById("timeDisplay");
	var fb = document.getElementById("fb");
	var pl = document.getElementById("pl");
	var i = document.getElementById("flip");
	var ib = document.getElementById("fliprollie");
	var sh = document.getElementById("shuffle");
	var rp = document.getElementById("repeat");
	
	slider.style.visibility = "hidden";
	knob.style.visibility = "hidden";
	time.style.visibility = "hidden";
	fb.style.visibility = "hidden";
	pl.style.visibility = "hidden";
	i.style.visibility = "hidden";
	ib.style.visibility = "hidden";
	sh.style.visibility = "hidden";
	rp.style.visibility = "hidden";
	
	if (window.widget)
		widget.prepareForTransition("ToBack");
	
	front.style.display="none";
	back.style.display="block";
	document.getElementById('fliprollie').style.display = 'none';
	
	if (running)
		updatePlaylists();
	if (window.widget)		
		setTimeout ('widget.performTransition();', 0);	

	backside = true;
}

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
	document.getElementById('flip').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}

function doneMouseUp(event)
{
	var front = document.getElementById("body");
	var back = document.getElementById("behind");
	var slider = document.getElementById("ds");
	var knob = document.getElementById("dk");
	var time = document.getElementById("timeDisplay");
	var fb = document.getElementById("fb");
	var pl = document.getElementById("pl");
	var i = document.getElementById("flip");
	var ib = document.getElementById("fliprollie");
	var sh = document.getElementById("shuffle");
	var rp = document.getElementById("repeat");
	
	slider.style.visibility = "visible";
	knob.style.visibility = "visible";
	time.style.visibility = "visible";
	fb.style.visibility = "visible";
	pl.style.visibility = "visible";
	i.style.visibility = "visible";
	ib.style.visibility = "visible";
	sh.style.visibility = "visible";
	rp.style.visibility = "visible";
	
	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	back.style.display="none";
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
	backside = false;

	if (gPlaylistChanged && iTunes) {
		if (isPlaying)
			iTunes.playPlaylist();
		shuffleState = iTunes.shuffle();
		document.getElementById("shuffle").src = shuffleState? "Images/shuffle_on.png" :"Images/shuffle_off.png";
		repeatState = iTunes.songRepeat();
		document.getElementById("repeat").src = "Images/repeat_" + repeatState + ".png";		
	}
}

function updatePlaylists() {
	if (iTunes) {
		if (iTunes.fetchPlaylists()) {
			
			var popup = document.getElementById("playlist-popup");
			
			popup.options.length = 0; // clear the current list
			
			var lCount = iTunes.playlistCount();
			for (var list = 0; list < lCount; list++) {
				var listName = iTunes.playlistNameForIndex(list);
				if (listName != "missing value") {
					var newList = new Option(listName);
					popup.options[popup.options.length] = newList;
				}
			}
			
			var myIndex = parseInt(iTunes.currentPlaylistIndex());
			if (myIndex < 0) // iTune is not playing, so doesn't have a playlist
				myIndex = gLastPlaylist;
				
			popup.options[myIndex].selected = true;
			gPlaylistChanged = false;
		}
		
		shuffleState = iTunes.shuffle();
		repeatState = iTunes.songRepeat();
	}
	
	document.getElementById("shuffle").src = shuffleState? "Images/shuffle_on.png" :"Images/shuffle_off.png";
	document.getElementById("repeat").src = "Images/repeat_" + repeatState + ".png";
}

function playlistchanged(elem)
{	
	var list = elem.selectedIndex;
	
	if (running) {
		gLastPlaylist = list;
		if (iTunes) iTunes.setCurrentPlaylist(gLastPlaylist);
		gPlaylistChanged = true;
		
		if (window.widget)
		{
			widget.setPreferenceForKey(gLastPlaylist, createkey("playlistsave"));
		}
	}
}

function toggleShuffle(event) {
	if (running) {
		shuffleState = shuffleState? 0: 1;
		if (iTunes) {
			iTunes.setShuffle(shuffleState? 1: 0);
			shuffleState = iTunes.shuffle();
		}
		document.getElementById("shuffle").src = shuffleState? "Images/shuffle_on.png": "Images/shuffle_off.png";
	}
}

function incrementRepeat(event) {
	if (running) {
		var value = 0;
		
		if (repeatState == "off") {
			repeatState = "all";
			value = 2;
		}
		else if (repeatState == "all") {
			repeatState = "one";
			value = 1;
		}
		else if (repeatState == "one") {
			repeatState = "off";
			value = 0;
		}
		if (iTunes) {
			iTunes.setRepeat(value);
			repeateState = iTunes.songRepeat();
		}
		document.getElementById("repeat").src = "Images/repeat_" + repeatState + ".png";
	}
}

function debug(msg) {
	if (!debug.box) {
		debug.box = document.createElement("div");
		debug.box.setAttribute("style", "background-color: white; " +
										"font-family: monospace; " +
										"border: solid black 3px; " +
										"padding: 10px;");
		document.body.appendChild(debug.box);
		debug.box.innerHTML = "<h1 style='text-align:center'>Debug Output</h1>";
	}
	
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	debug.box.appendChild(p);
}




function hide()
{
    // Stop any timers to prevent CPU usage
}

//
// Function: show()
// Called when the widget has been shown
//
function show()
{
    // Refresh feed if 15 minutes have passed since the last update
    var now = (new Date).getTime();
    if ((now - lastUpdated) > 15 * 60 * 1000) {
        refreshFeed();
    }
}



/*********************************/
// HIDING AND SHOWING PREFERENCES
/*********************************/

// showPrefs() is called when the preferences flipper is clicked upon.  It freezes the front of the widget,
// hides the front div, unhides the back div, and then flips the widget over.

function showPrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToBack");		// freezes the widget so that you can change it without the user noticing
	
	front.style.display="none";		// hide the front
	back.style.display="block";		// show the back
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget over	

	document.getElementById('fliprollie').style.display = 'none';  // clean up the front side - hide the circle behind the info button

}


// hidePrefs() is called by the done button on the back side of the widget.  It performs the opposite transition
// as showPrefs() does.

function hidePrefs()
{
	var front = document.getElementById("front");
	var back = document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");		// freezes the widget and prepares it for the flip back to the front
	
	back.style.display="none";			// hide the back
	front.style.display="block";		// show the front
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);		// and flip the widget back to the front
}


// PREFERENCE BUTTON ANIMATION (- the pref flipper fade in/out)

var flipShown = false;		// a flag used to signify if the flipper is currently shown or not.


// A structure that holds information that is needed for the animation to run.
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};

function mousemove (event)
{
	if (!flipShown)			// if the preferences flipper is not already showing...
	{
		if (animation.timer != null)			// reset the animation timer value, in case a value was left behind
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13; 		// set it back one frame
		
		animation.duration = 500;												// animation time, in ms
		animation.starttime = starttime;										// specify the start time
		animation.firstElement = document.getElementById ('flip');		// specify the element to fade
		animation.timer = setInterval ("animate();", 13);						// set the animation function
		animation.from = animation.now;											// beginning opacity (not ness. 0)
		animation.to = 1.0;														// final opacity
		animate();																// begin animation
		flipShown = true;														// mark the flipper as animated
	}
}
function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (animation.timer != null)
		{
			clearInterval (animation.timer);
			animation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - 13;
		
		animation.duration = 500;
		animation.starttime = starttime;
		animation.firstElement = document.getElementById ('flip');
		animation.timer = setInterval ("animate();", 13);
		animation.from = animation.now;
		animation.to = 0.0;
		animate();
		flipShown = false;
	}
}


function animate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-animation.starttime, 0, animation.duration);
	
	if (T >= animation.duration)
	{
		clearInterval (animation.timer);
		animation.timer = null;
		animation.now = animation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
		animation.now = computeNextFloat (animation.from, animation.to, ease);
	}
	
	animation.firstElement.style.opacity = animation.now;
}

function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}


google.load("feeds", "1") //Load Google Ajax Feed API (version 1)

function rssdisplayer(divid, url, feedlimit, showoptions){
this.showoptions=showoptions || "" //get string of options to show ("date" and/or "description")
var feedpointer=new google.feeds.Feed(url) //create new instance of Google Ajax Feed API
feedpointer.setNumEntries(feedlimit) //set number of items to display
document.write('<div id="'+divid+'">Loading feed...</div>')
this.feedcontainer=document.getElementById(divid)
var displayer=this
feedpointer.load(function(r){displayer.formatoutput(r)}) //call Feed.load() to retrieve and output RSS feed
}


rssdisplayer.prototype.formatdate=function(datestr){
var itemdate=new Date(datestr)
return "<span style='color:gray; font-size: 90%'>"+itemdate.toLocaleString()+"</span>"
}


rssdisplayer.prototype.formatoutput=function(result){
if (!result.error){ //if RSS feed successfully fetched
var thefeeds=result.feed.entries //get all feed entries as a JSON array
var rssoutput="<ul>"
for (var i=0; i<thefeeds.length; i++){ //loop through entries
var itemtitle="<a onclick=\"widget.openURL('" + thefeeds[i].link + "');\">" + thefeeds[i].title + "</a>"
var itemdate=/date/i.test(this.showoptions)? this.formatdate(thefeeds[i].publishedDate) : ""
var itemdescription=/description/i.test(this.showoptions)? "<br />"+thefeeds[i].content : /snippet/i.test(this.showoptions)? "<br />"+thefeeds[i].contentSnippet  : ""
rssoutput+="<li>" + itemtitle + "</li>"
}
rssoutput+="</ul>"
this.feedcontainer.innerHTML=rssoutput
}
else //else, output error
alert("Error fetching feeds: "+result.error.message)
}
//USAGE SYNTAX: new rssdisplayer("divid", "rssurl", numberofitems, "displayoptions")
//new rssdisplayer("adiv", "http://www.cssdrive.com/index.php/news/rss_2.0/", 5, "date, description")
